clear
set more off

****************************************************************
** By country, count the number of targets for which countries are currently on-track
****************************************************************

use "SDG2030_table.dta", clear

***Because NMR is a subset of U5MR, only count countries as meeting target if they meet both
gen u5mr_nmr_sdgyes2030= 1 if u5mr_sdgyes2030_0515==1 & nmr_sdgyes2030_0515==1
replace u5mr_nmr_sdgyes2030= 0 if (u5mr_sdgyes2030_0515!=1 | nmr_sdgyes2030_0515!=1 ) & u5mr_sdgyes2030_0515!=. & nmr_sdgyes2030_0515!=.

*********
**Health + Water and Sanitation (U5MR, MMR, NMR, Water, Sanitation)
*********

* For Figure 1 (Map): create a count of countries on-track for 4 SDG-targets
gen healthwssdgyes2030 =  u5mr_nmr_sdgyes2030 + mmr_sdgyes2030_0515 + water_sdgyes2030 + sanitation_sdgyes2030 if u5mr_nmr_sdgyes2030!=. & mmr_sdgyes2030_0515!=. & water_sdgyes2030!=. & sanitation_sdgyes2030!=. 

 *a. all countries
gen count =1
egen healthws_0_2030count = sum(count) if healthwssdgyes2030==0  
 label variable healthws_0_2030count "count of countries on-track for 0 SDGs"
egen healthws_1_2030count = sum(count) if healthwssdgyes2030==1  
 label variable healthws_1_2030count "count of countries on-track for 1 SDGs"
egen healthws_2_2030count = sum(count) if healthwssdgyes2030==2  
 label variable healthws_2_2030count "count of countries on-track for 2 SDGs"
egen healthws_3_2030count = sum(count) if healthwssdgyes2030==3  
 label variable healthws_3_2030count "count of countries on-track for 3 SDGs"
egen healthws_4_2030count = sum(count) if healthwssdgyes2030==4  
 label variable healthws_4_2030count "count of countries on-track for 4 SDGs"

save "SDG_fullcounts.dta", replace

* For Box 1: 37 top priority countries
**tab CountryName if healthwssdgyes2030==0

